//
//  BRTMUserManager.h
//  BRTM
//
//  Created by xyp on 2021/1/5.
//

#import <Foundation/Foundation.h>

#import "NSError+BRTMError.h"

@class BRTMRoom;

NS_ASSUME_NONNULL_BEGIN

// user相关的代理回调
@protocol BRTMUserDelegate <NSObject>
@optional
// 用户变化
- (void)room:(BRTMRoom *)room didUsersChange:(NSArray <BJLUser *> *)users;
// user进入房间
- (void)room:(BRTMRoom *)room didUserEnter:(BJLUser *)user;
// user退出房间
- (void)room:(BRTMRoom *)room didUserExit:(BJLUser *)user;
// 方法 -searchUserWithUserID: 的回调
- (void)room:(BRTMRoom *)room didSearchUsers:(NSArray <BJLUser *> *)users;
// 方法 updateAuth:index:toUserID 的回调
- (void)room:(BRTMRoom *)room didUserAuthUpdateWithIndex:(NSInteger)index auth:(BOOL)authorized userID:(NSString *)userID;

@end

@interface BRTMUserManager : NSObject

- (instancetype)init NS_UNAVAILABLE;

/** user相关的代理 */
@property (nonatomic, weak) id <BRTMUserDelegate> userDelegate;

/** 在线人数 */
@property (nonatomic, readonly) NSInteger onlineUsersTotalCount;

/**
 在线用户，分页加载
 #discussion `loadMoreOnlineUsersWithCount:` 导致的更新会先重置为 nil，然后再赋值，可用来区分单个更新
 #discussion 参考 `loadMoreOnlineUsersWithCount:`
 */
@property (nonatomic, readonly, copy, nullable) NSArray<__kindof BJLUser *> *users;

/**
 加载更多用户
 #param count 小于0内部则默认为20，大于30时，内部默认30
 */
- (nullable BRTMError *)loadMoreOnlineUsersWithCount:(NSInteger)count;

/** 搜索用户, 会回调 -room:didSearchUsers: */
- (nullable BRTMError *)searchUserWithUserID:(NSString *)userID;

/**
 获取 index 位对应的权限
 #userID: 要获取权限人的 userID
 #index: 要获取权限的 index
 #note: 仅支持获取已加载到本地的用户的权限
 */
- (BOOL)authWithUserID:(NSString *)userID index:(NSInteger)index;

/**
 修改指定用户的 index 位对应的权限
 #param index 0 - 63
*/
- (nullable BRTMError *)updateAuth:(BOOL)authorized index:(NSInteger)index toUserID:(NSString *)toUserID;

@end

NS_ASSUME_NONNULL_END
