//
//  BRTMRoomVM.h
//  BRTMLiveCore
//
//  Created by MingLQ on 2016-12-05.
//  Copyright © 2016 BaijiaYun. All rights reserved.
//

#import "BRTMBaseVM.h"

NS_ASSUME_NONNULL_BEGIN

/** ### 教室信息、状态，用户信息，公告等 */
@interface BRTMRoomVM : BRTMBaseVM

#pragma mark - 定制信令

/**
 发送定制广播信令
 #discussion 发送定制广播信令
 #param key     信令类型
 #param value   信令内容，合法的 JSON 数据类型 - #see `[NSJSONSerialization isValidJSONObject:]`，序列化成字符串后不能过长，一般不超过 1024 个字符
 #param cache   是否缓存，缓存的信令可以通过 `requestCustomizedBroadcastCache:` 方法重新请求
 #return BJLError:
 BRTMErrorCode_invalidArguments  不支持的 key，内容为空或者内容过长
 BRTMErrorCode_areYouRobot       发送频率过快，要求每秒不超过 5 条、并且每分钟不超过 60 条
 */
- (nullable BJLError *)sendCustomizedBroadcast:(NSString *)key value:(id _Nullable)value cache:(BOOL)cache;

/**
 收到定制广播信令
 #param key     信令类型
 #param value   信令内容，类型可能是字符串或者字典等 JSON 数据类型
 #param isCache 是否为缓存
 */
- (BJLObservable)didReceiveCustomizedBroadcast:(NSString *)key value:(nullable id)value isCache:(BOOL)isCache;

/**
 获取定制广播信令缓存
 #discussion 进教室后调用此方法可以获取定制广播信令的缓存，结果回调 `didReceiveCustomizedBroadcast:value:isCache:`
 #param key     信令类型
 #return BJLError:
 BRTMErrorCode_invalidArguments  不支持的 key
 BRTMErrorCode_areYouRobot       发送频率过快，要求每秒不超过 5 条、并且每分钟不超过 60 条
 */
- (nullable BJLError *)requestCustomizedBroadcastCache:(NSString *)key;

/**
 * 清除定制广播信令缓存
 *
 * @param key     信令类型
 */
- (nullable BJLError *)requestCustomizedBroadcastCacheClear:(NSString *)key;

/**
 给指定用户发送自定义信令
 #param key     自定义的key
 #param value   信令内容，类型可能是字符串或者字典等 JSON 数据类型
 #param userId     指定用户ID
 #return BJLError:
 BRTMErrorCode_invalidArguments  不支持的 key
 BRTMErrorCode_areYouRobot       发送频率过快，要求每秒不超过 5 条、并且每分钟不超过 60 条
 */
- (nullable BJLError *)sendSignalWithKey:(NSString *)key value:(id _Nullable)value toUserNumber:(NSString *)number;

/**
 收到指定用户发送的信令
 #param key     自定义的key
 #param value   信令内容，类型可能是字符串或者字典等 JSON 数据类型
 #param userId     发送信令的用户ID
 */
- (BJLObservable)didReceiveSignalWithKey:(NSString *)key value:(id)value fromRSUserID:(NSString *)rsUserID;

@end

NS_ASSUME_NONNULL_END
