//
//  BRTMRoomInfo.h
//  BRTMLiveCore
//
//  Created by MingLQ on 2016-12-05.
//  Copyright © 2016 BaijiaYun. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "BRTMConstants.h"

NS_ASSUME_NONNULL_BEGIN

@protocol BRTMRoomInfo <NSObject>

/// 用户方设置的roomId
@property (nonatomic, readonly) NSString *roomId;
/// 用户设置的房间名称, 可能为空
@property (nonatomic, readonly, nullable) NSString *title;
/// 用户方设置的userId
@property (nonatomic, readonly) NSString *userId;
@property (nonatomic, readonly) NSTimeInterval startTimeInterval, startTimeMillisecond,  endTimeInterval;

//@property (nonatomic, readonly) BRTMRoomType roomType;
//@property (nonatomic, readonly) BRTMRoomGroupType roomGroupType;
//@property (nonatomic, readonly) BRTMRoomNewGroupType newRoomGroupType;
//@property (nonatomic, readonly) BOOL enableGroupUser;// 分组用户可见
@property (nonatomic, readonly) BOOL enableGroupInSmallRoom;// 大小班切换到大班之后是否允许分组，该设置仅对旧版分组直播有效
@property (nonatomic, readonly) BOOL enableGroupInNewSmallRoom;// 大小班切换到大班之后是否允许分组，该设置对新版线上双师和分组课堂有效

/** 专业版小班课布局模板 */
//@property (nonatomic, readonly) BRTMIcTemplateType interactiveClassTemplateType;

@property (nonatomic, readonly) NSString *partnerID;
@property (nonatomic, readonly) NSString *environmentName;
@property (nonatomic, readonly, nullable) NSString *customerSupportMessage;

@end

NS_ASSUME_NONNULL_END
