//
//  BRTMOnlineUserVM.h
//  BRTM
//
//  Created by xyp on 2020/12/29.
//  Copyright © 2020 BaijiaYun. All rights reserved.
//

#if __has_feature(modules) && BJL_USE_SEMANTIC_IMPORT
@import BJLiveBase;
#else
#import <BJLiveBase/BJLiveBase.h>
#endif

#import "BRTMBaseVM.h"

NS_ASSUME_NONNULL_BEGIN

@interface BRTMOnlineUserVM : BRTMBaseVM

/** 在线人数 */
@property (nonatomic, readonly) NSInteger onlineUsersTotalCount;

- (BJLObservable)onlineUserDidChange:(NSArray <BJLUser *> *)users;
/**
 在线用户，分页加载
 #discussion `loadMoreOnlineUsersWithCount:` 导致的更新会先重置为 nil，然后再赋值，可用来区分单个更新
 #discussion 参考 `loadMoreOnlineUsersWithCount:`
 */
@property (nonatomic, readonly, copy, nullable) NSArray<__kindof BJLUser *> *users;

/**
 `onlineTeacher`、`currentPresenter` 是否加载完成
 #discussion 1、连接教室后、掉线重新连接后，都会重置为 NO
 #discussion 2、然后重置 `onlineTeacher`、`currentPresenter`
 #discussion 3、然后自动加载 `onlineTeacher`、`currentPresenter`
 #discussion 4、加载完成后为 YES，`onlineTeacher`、`currentPresenter` 可能为 nil
 */
//@property (nonatomic, readonly) BOOL activeUsersSynced;


/** 获取当前登录用户所在group是否有更多在线用户未加载 */
//@property (nonatomic, readonly) BOOL hasMoreOnlineUsers; // NON-KVO

/** 获取某一个分组是否有更多在线用户未加载 */
//- (BOOL)hasMoreOnlineUsersofGroup:(NSInteger)groupID;

/**
 加载更多在线用户
 #discussion 连接教室后、掉线重新连接后自动调用加载
 #discussion 加载成功更新 `onlineUsers`
 #discussion 参考 `hasMoreOnlineUsers`
 #param count 传 0 默认 20、最多 30
 #return BJLError:
 BJLErrorCode_invalidCalling    错误调用，如 `hasMoreOnlineUsers` 为 NO 时调用此方法
 */
- (nullable BJLError *)loadMoreOnlineUsersWithCount:(NSInteger)count;

/**
 有用户进入教室
 #discussion 批量更新时不会调用
 #discussion 同时更新 `onlineUsers`
 #param user 用户
 */
- (BJLObservable)onlineUserDidEnter:(BJLUser *)user;

/**
 有用户退出教室
 #discussion 批量更新时不会调用
 #discussion 同时更新 `onlineUsers`
 #param user 用户
 */
- (BJLObservable)onlineUserDidExit:(BJLUser *)user;

/**
 根据 userID 获取user, 监听 didSearchUser 获取对应的 user
 */
- (nullable BRTMError *)searchUserWithUserID:(NSString *)userID;

/**
 请求 searchUserWithUserID 之后, 获取对应的 users, 可能为空
 */
- (BJLObservable)didSearchUsers:(nullable NSArray <BJLUser *> *)users;

#pragma mark - 权限

/**
 指定用户权限更新
 #index 0 - 63
 */
- (nullable BRTMError *)updateAuth:(BOOL)authorized index:(NSInteger)index toUserID:(NSString *)toUserID;

/**
 获取 index 位对应的权限
 #userID: 要获取权限人的 userID
 #index: 要获取权限的 index
 #note: 仅支持获取已加载到本地的用户的权限
 */
- (BOOL)authWithUserID:(NSString *)userID index:(NSInteger)index;

/**
 *  用户权限更新
 */
- (BJLObservable)onResponseUserAuthUpdateWithIndex:(NSInteger)index auth:(BOOL)auth userID:(NSString *)userID;

#pragma mark - 分组

/** 教室内分组信息
 #discussion 0表示未分组, groupList不包含groupID = 0的数据
 */
@property (nonatomic, readonly, copy, nullable) NSArray<BJLUserGroup *> *groupList;

/** 教室内分组人数信息  <groupID, count> */
@property (nonatomic, readonly, copy, nullable) NSDictionary<NSString *, NSNumber *> *groupCountDic;

/**
 * 踢出教室
 */
- (nullable BJLError *)kickOutUserWithNumber:(NSString *)number;

@end

NS_ASSUME_NONNULL_END
