//
//  BRTMFeatureConfig.h
//  BRTMLiveCore
//
//  Created by 杨磊 on 16/7/18.
//  Copyright © 2016 BaijiaYun. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "BRTMConstants.h"

NS_ASSUME_NONNULL_BEGIN

FOUNDATION_EXPORT const NSInteger BRTMDoodleVersion;

@interface BRTMFeatureConfig : NSObject <NSCopying, NSCoding>

#pragma mark - common

// 隐藏技术支持消息, #see BJLClientType
@property (nonatomic, readonly) NSArray<NSNumber *> *forbiddenClientTypes;

// 禁用 H5 实现的 PPT 动画
@property (nonatomic, readonly) BOOL disablePPTAnimation;
// 支持多白板
@property (nonatomic, readonly) BOOL enableMutiBoard;
// 支持私聊
@property (nonatomic, readonly) BOOL enableWhisper;
// 支持全体禁言下私聊老师
@property (nonatomic, readonly) BOOL enableWhisperToTeacherWhenForbidAll;

// 允许小班课黑板读取主题配置，不使用配置的黑板背景图
@property (nonatomic, readonly) BOOL enableNewBlackboardConfig;

// 小班课黑板背景图
@property (nonatomic, readonly) NSString *blackboardURLString;

@end

NS_ASSUME_NONNULL_END
