//
//  BRTMDrawingVM.h
//  BRTMLiveCore
//
//  Created by MingLQ on 2016-12-08.
//  Copyright © 2016 BaijiaYun. All rights reserved.
//

#if __has_feature(modules) && BJL_USE_SEMANTIC_IMPORT
@import BJLiveBase;
#else
#import <BJLiveBase/BJLiveBase.h>
#endif

#import "BRTMBaseVM.h"
#import "BRTMConstants.h"

NS_ASSUME_NONNULL_BEGIN

/** ### 画笔管理 */
@interface BRTMDrawingVM : BRTMBaseVM

/** 画笔操作模式 */
@property (nonatomic, readonly) BJLBrushOperateMode brushOperateMode;

/** 画笔类型 */
@property (nonatomic) BJLDrawingShapeType drawingShapeType;

/** 画笔边框颜色 */
@property (nonatomic, nonnull) NSString *strokeColor;

/** 画笔边框颜色透明度，取值范围 0~1 */
@property (nonatomic) CGFloat strokeAlpha;

/** 画笔填充颜色 */
@property (nonatomic, nullable) NSString *fillColor;

/** 画笔填充颜色透明度，取值范围 0~1, fillColor 不为空时有效 */
@property (nonatomic) CGFloat fillAlpha;

/** doodle 画笔线宽 */
@property (nonatomic) CGFloat doodleStrokeWidth;

/** 图形画笔边框线宽 */
@property (nonatomic) CGFloat shapeStrokeWidth;

/**
 文字画笔字体大小,  范围 [0.0001, 1.0], 默认值0.02
 渲染文字时的 字体 为 textFontSize * 画布宽度
 */
@property (nonatomic) CGFloat textFontSize;

/** 文字画笔是否加粗 */
@property (nonatomic) BOOL textBold;

/** 文字画笔是否为斜体 */
@property (nonatomic) BOOL textItalic;

/** 画笔开关状态，参考 `updatePaintEnabled:` */
@property (nonatomic, readonly) BOOL paintEnabled;

/** doodle 画笔是否虚线 */
@property (nonatomic) BOOL isDottedLine;

/** 选中画笔时是否显示归属信息 */
@property (nonatomic) BOOL showBrushOwnerNameWhenSelected;

/** 是否有选中的画笔 */
@property (nonatomic) BOOL hasSelectedShape;

/**
 开启、关闭画笔
 #param paintEnabled YES：开启，NO：关闭
 #return BJLError:
 #discussion 开启画笔时，单文档实例情况下如果本地页数与服务端页数不同步则无法绘制
 */
- (nullable BJLError *)updatePaintEnabled:(BOOL)paintEnabled;

/**
 更新画笔操作模式
 #param operateMode 操作模式
 #return BJLError:
 #discussion BRTMErrorCode_invalidCalling paintEnabled 是 NO
 */
- (nullable BJLError *)updateBrushOperateMode:(BJLBrushOperateMode)operateMode;

/**
 添加图片画笔
 #param imageURL 图片 url
 #param relativeFrame 图片相对于画布的 frame, 各项数值取值范围为 [0.0, 1.0]
 #param documentID 目标文档 ID
 #param pageIndex   目标页
 #param isWritingBoard   是否为小黑板
 #return BRTMErrorCode_invalidCalling paintEnabled 是 NO
 */
- (nullable BJLError *)addImageShapeWithURL:(NSString *)imageURL
                              relativeFrame:(CGRect)relativeFrame
                               toDocumentID:(NSString *)documentID
                                  pageIndex:(NSUInteger)pageIndex
                             isWritingBoard:(BOOL)isWritingBoard;

#pragma mark - 激光笔
/**
 改变内部实现的激光笔的图片
 */
@property (nonatomic) UIImage *laserPointImage;

/**
 是否自定义激光笔, 默认为NO: 使用内部的实现.
 */
@property (nonatomic) BOOL isCustomLaserPoint;

/**
 激光笔位置移动请求
 #param location         激光笔目标位置
 #param documentID       激光笔所在文档的 ID
 #param pageIndex        激光笔所在文档页码
 */
- (nullable BJLError *)moveLaserPointToLocation:(CGPoint)location
                                     documentID:(nonnull NSString *)documentID
                                      pageIndex:(NSUInteger)pageIndex;

/**
 激光笔位置移动监听
 #param location         激光笔位置
 #param documentID       激光笔所在文档的 ID
 #param pageIndex        激光笔所在文档页码
 */
- (BJLObservable)didLaserPointMoveToLocation:(CGPoint)location
                                  documentID:(NSString *)documentID
                                   pageIndex:(NSUInteger)pageIndex;

/**
 落笔位置点同步

 #param location         画笔位置
 #param documentID       画笔所在文档的 ID
 #param pageIndex        画笔所在文档页码
 */
- (BJLObservable)didMousePointMoveToLocation:(CGPoint)location
                                  documentID:(NSString *)documentID
                                   pageIndex:(NSUInteger)pageIndex;

@end

NS_ASSUME_NONNULL_END
