//
//  BRTMDocumentDelegate.h
//  BRTM
//
//  Created by xyp on 2021/2/20.
//

#import <Foundation/Foundation.h>

@class BRTMRoom;

NS_ASSUME_NONNULL_BEGIN

/// 文档和画笔相关的代理回调
@protocol BRTMDocumentDelegate <NSObject>
@optional

/// 收到所有文档的回调
- (void)room:(BRTMRoom *)room didReceiveAllDocuments:(nullable NSArray<BJLDocument *> *)allDocuments currentDocumentID:(NSString *)documentID;

/// 增加一页白板的回调
- (void)room:(BRTMRoom *)room document:(BJLDocument *)document didAddPage:(NSInteger)pageIndex;

/// 删除一页白板的回调
/// @param pageIndex 白板id
- (void)room:(BRTMRoom *)room document:(BJLDocument *)document didDeletePageWithIndex:(NSInteger)pageIndex;

/// 增加ppt文档的回调
- (void)room:(BRTMRoom *)room didAddDocument:(BJLDocument *)document;

/// 删除ppt文档的回调
- (void)room:(BRTMRoom *)room didDeleteDocument:(BJLDocument *)document;

/// 更新ppt文档的回调
- (void)room:(BRTMRoom *)room didUpdateDocument:(BJLDocument *)document;

/// 文档翻页的回调
- (void)room:(BRTMRoom *)room document:(BJLDocument *)document didChangePage:(NSInteger)pageIndex;

/// 动态和静态ppt之间的切换的回调
/// @param type 动态/静态课件的类型
- (void)room:(BRTMRoom *)room document:(BJLDocument *)document didChangeType:(BJLPPTViewType)type;

/// 画笔: 触摸事件将要开始的回调
- (void)roomWillBeginGestureWith:(BRTMRoom *)room;

/// 某一页画笔清空的回调
- (void)room:(BRTMRoom *)room didClearShapesWithDocumentID:(NSString *)documentID pageID:(NSUInteger)pageID userNumber:(nullable NSString *)userNumber;

/// 激光笔移动的回调
// laserPointDidMoveToLocation
- (void)room:(BRTMRoom *)room didLaserPointMoveToLocation:(CGPoint)location documentID:(NSString *)documentID pageID:(NSUInteger)pageID;
 
@end

NS_ASSUME_NONNULL_END
