//
//  BRTMDelegate.h
//  BRTM
//
//  Created by xyp on 2020/11/9.
//  Copyright © 2020 BaijiaYun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NSError+BRTMError.h"

@class BRTMRoom;

NS_ASSUME_NONNULL_BEGIN

/// 房间相关的代理回调
@protocol BRTMDelegate <NSObject>
@optional

/// 加入房间成功
/// 成功时所有初始化工作已经结束，vm 的状态、数据已经和服务端同步，并可调用 vm 方法
- (void)didJoinRoomSuccess:(BRTMRoom *)room;

/// 加入房间失败
/// @param error error, 参考BRTMErrorCode
- (void)didJoinRoomFailure:(BRTMRoom *)room error:(BRTMError *)error;

/// 即将离开房间的通知
/// @param error 错误信息, 主退出为空, 否则为异常退出
- (void)willLeaveRoom:(BRTMRoom *)room error:(nullable BRTMError *)error;

/// 离开房间的通知
/// @param error 错误信息, 主退出为空, 否则为异常退出
- (void)didLeaveRoom:(BRTMRoom *)room error:(nullable BRTMError *)error;

/// 当前房间关闭/解散
//- (void)roomDidClosed:(BRTMRoom *)room;

/// 收到错误通知
/// @param error 错误信息
- (void)room:(BRTMRoom *)room onError:(nullable BRTMError *)error;

/// 房间内的 document 服务是否可用
/// @param enable 是否可用, 当 enable 为 NO 时, 内部会调用 destoryDocumentManager 销毁documentManger
/// @param userID 触发此广播的userID, 初次进房间的时候, userID 为空
- (void)room:(BRTMRoom *)room documentServiceIsEnable:(BOOL)enable senderByUserID:(nullable NSString *)userID;

@end

/// 消息相关的代理回调
@protocol BRTMMessageDelegate <NSObject>
@optional

/// 收到广播消息的回调
- (void)room:(BRTMRoom *)room didReceiveBoardcastMessageWithKey:(NSString *)key value:(id)value cache:(BOOL)cache;

/// 收到某个用户发来的消息
- (void)room:(BRTMRoom *)room didReceiveMessageWithKey:(NSString *)key value:(id)value fromUserID:(NSString *)userID;

@end

NS_ASSUME_NONNULL_END
