//
//  BRTMConstants.h
//  BRTMLiveCore
//
//  Created by MingLQ on 2016-11-26.
//  Copyright © 2016 BaijiaYun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/** WebSocket 请求超时时间 */
FOUNDATION_EXPORT const NSTimeInterval BRTMWebSocketTimeoutInterval;

/** 服务端信令协议的版本 */
FOUNDATION_EXPORT const NSInteger BRTMRoomServerVersion;

/** 部署环境(内部使用) */
typedef NS_ENUM(NSInteger, BRTMDeployType) {
    BRTMDeployType_www, // 正式环境
    BRTMDeployType_beta,
    BRTMDeployType_test,
    _BRTMDeployType_count
};

/** 用户角色 */
typedef NS_ENUM(NSInteger, BRTMUserRole) {
    /** 普通用户 */
    BRTMUserRole_user = 0,
    /** 超级管理员 */
    BRTMUserRole_root = 1,
    /** 管理员 */
    BRTMUserRole_admin = 2,
};

NS_ASSUME_NONNULL_END
