//
//  BRTMChatManager.h
//  BRTM
//
//  Created by xyp on 2020/12/28.
//  Copyright © 2020 BaijiaYun. All rights reserved.
//

#import <Foundation/Foundation.h>
#if __has_feature(modules) && BJL_USE_SEMANTIC_IMPORT
@import BJLiveBase;
#else
#import <BJLiveBase/BJLiveBase.h>
#endif


#import "NSError+BRTMError.h"

NS_ASSUME_NONNULL_BEGIN

@class BRTMRoom;

/// 聊天相关的代理回调
@protocol BRTMChatDelegate <NSObject>
@optional

/// 收到历史消息 - 需要覆盖更新本地缓存的消息
/// 首次进教室或断开重连会收到此回调
- (void)room:(BRTMRoom *)room didReceivedHistoryMessages:(nullable NSArray<BJLMessage *> *)historyMessages;

/// 收到的消息 - 增量更新
- (void)room:(BRTMRoom *)room didReceiveMessages:(NSArray<BJLMessage *> *)messages;

@end

@interface BRTMChatManager : NSObject

- (instancetype)init NS_UNAVAILABLE;

/// 聊天相关的代理
@property (nonatomic, weak) id <BRTMChatDelegate> chatDelegate;

/// 发送文字消息
- (BRTMError *)sendMessage:(NSString *)message;

/// 指定频道，发送文字消息
- (BRTMError *)sendMessage:(NSString *)message toChannel:(nullable NSString *)channel;

/// 指定对象，发送文字消息
- (BRTMError *)sendMessage:(NSString *)message toUser:(nullable BJLUser *)user;

@end

NS_ASSUME_NONNULL_END
