/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.glide.repackaged.com.google.common.collect;

import com.baijiayun.glide.repackaged.com.google.common.base.Function;
import com.baijiayun.glide.repackaged.com.google.common.base.Preconditions;
import com.baijiayun.glide.repackaged.com.google.common.base.Predicate;
import com.baijiayun.glide.repackaged.com.google.common.collect.FluentIterable;
import com.baijiayun.glide.repackaged.com.google.common.collect.Iterators;
import java.util.Iterator;

public final class Iterables {
    public static String toString(Iterable<?> iterable) {
        return Iterators.toString(iterable.iterator());
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    public static <T> Iterable<T> filter(final Iterable<T> unfiltered, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(predicate);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(unfiltered.iterator(), predicate);
            }
        };
    }

    public static <F, T> Iterable<T> transform(final Iterable<F> fromIterable, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(fromIterable);
        Preconditions.checkNotNull(function);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.transform(fromIterable.iterator(), function);
            }
        };
    }

    public static <T> T getFirst(Iterable<? extends T> iterable, T defaultValue) {
        return Iterators.getNext(iterable.iterator(), defaultValue);
    }
}

