/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.glide.annotation.compiler;

import com.baijiayun.glide.annotation.GlideExtension;
import com.baijiayun.glide.annotation.GlideModule;
import com.baijiayun.glide.annotation.compiler.Index;
import com.baijiayun.glide.annotation.compiler.ProcessorUtil;
import com.baijiayun.glide.repackaged.com.squareup.javapoet.AnnotationSpec;
import com.baijiayun.glide.repackaged.com.squareup.javapoet.ClassName;
import com.baijiayun.glide.repackaged.com.squareup.javapoet.TypeSpec;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

final class IndexerGenerator {
    private final ProcessorUtil processorUtil;

    IndexerGenerator(ProcessorUtil processorUtil) {
        this.processorUtil = processorUtil;
    }

    TypeSpec generate(List<TypeElement> types) {
        ArrayList<TypeElement> modules = new ArrayList<TypeElement>();
        ArrayList<TypeElement> extensions = new ArrayList<TypeElement>();
        for (TypeElement element : types) {
            if (this.processorUtil.isExtension(element)) {
                extensions.add(element);
                continue;
            }
            if (this.processorUtil.isLibraryGlideModule(element)) {
                modules.add(element);
                continue;
            }
            throw new IllegalArgumentException("Unrecognized type: " + element);
        }
        if (!modules.isEmpty() && !extensions.isEmpty()) {
            throw new IllegalArgumentException("Given both modules and extensions, expected one or the other. Modules: " + modules + " Extensions: " + extensions);
        }
        if (!modules.isEmpty()) {
            return IndexerGenerator.generate(types, GlideModule.class);
        }
        return IndexerGenerator.generate(types, GlideExtension.class);
    }

    private static TypeSpec generate(List<TypeElement> libraryModules, Class<? extends Annotation> annotation) {
        AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder(Index.class);
        String value = IndexerGenerator.getAnnotationValue(annotation);
        for (TypeElement childModule : libraryModules) {
            annotationBuilder.addMember(value, "$S", ClassName.get(childModule).toString());
        }
        StringBuilder indexerName = new StringBuilder("GlideIndexer_" + annotation.getSimpleName() + "_");
        for (TypeElement element : libraryModules) {
            indexerName.append(element.getQualifiedName().toString().replace(".", "_"));
            indexerName.append("_");
        }
        indexerName = new StringBuilder(indexerName.substring(0, indexerName.length() - 1));
        return TypeSpec.classBuilder(indexerName.toString()).addAnnotation(annotationBuilder.build()).addModifiers(Modifier.PUBLIC).build();
    }

    private static String getAnnotationValue(Class<? extends Annotation> annotation) {
        if (annotation == GlideModule.class) {
            return "modules";
        }
        if (annotation == GlideExtension.class) {
            return "extensions";
        }
        throw new IllegalArgumentException("Unrecognized annotation: " + annotation);
    }
}

