/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.glide.annotation.compiler;

import com.baijiayun.glide.annotation.GlideExtension;
import com.baijiayun.glide.annotation.compiler.GlideExtensionValidator;
import com.baijiayun.glide.annotation.compiler.IndexerGenerator;
import com.baijiayun.glide.annotation.compiler.ProcessorUtil;
import com.baijiayun.glide.repackaged.com.squareup.javapoet.TypeSpec;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

final class ExtensionProcessor {
    private final ProcessorUtil processorUtil;
    private final IndexerGenerator indexerGenerator;
    private final GlideExtensionValidator extensionValidator;

    ExtensionProcessor(ProcessingEnvironment processingEnvironment, ProcessorUtil processorUtil, IndexerGenerator indexerGenerator) {
        this.processorUtil = processorUtil;
        this.indexerGenerator = indexerGenerator;
        this.extensionValidator = new GlideExtensionValidator(processingEnvironment, processorUtil);
    }

    boolean processExtensions(RoundEnvironment env) {
        List<TypeElement> elements = this.processorUtil.getElementsFor(GlideExtension.class, env);
        this.processorUtil.debugLog("Processing types : " + elements);
        for (TypeElement typeElement : elements) {
            this.extensionValidator.validateExtension(typeElement);
            this.processorUtil.debugLog("Processing elements: " + typeElement.getEnclosedElements());
        }
        if (elements.isEmpty()) {
            return false;
        }
        TypeSpec spec = this.indexerGenerator.generate(elements);
        this.processorUtil.writeIndexer(spec);
        return true;
    }

    Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(GlideExtension.class.getName());
    }
}

