/*
 *  Copyright 2015 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#import <Foundation/Foundation.h>
#if TARGET_OS_IPHONE
#import <UIKit/UIKit.h>
#endif

#import "RTCMacros.h"

NS_ASSUME_NONNULL_BEGIN

#if defined(WEBRTC_VLOUD_BUILD)
typedef NS_ENUM(NSInteger, RTCVideoRenderType) {
  RTCVideoRenderType_unknow = 0,
  RTCVideoRenderType_gl = 1,
  RTCVideoRenderType_metal = 2,
};

static NSString * const framesReceivedKey = @"framesReceived";
static NSString * const droppedKey = @"dropped";
static NSString * const renderedKey = @"rendered";
static NSString * const renderFpsKey = @"renderFps";
static NSString * const streamIDsKey = @"streamIDs";
static NSString * const nameKey = @"name";
static NSString * const durationKey = @"duration";
#endif

@class RTC_OBJC_TYPE(RTCVideoFrame);

RTC_OBJC_EXPORT
@protocol RTC_OBJC_TYPE
(RTCVideoRenderer)<NSObject>

#if defined(WEBRTC_VLOUD_BUILD)
@property (nonatomic, assign) BOOL isMirror;
@property (nonatomic, assign) RTCVideoRenderType renderType;
@property(nonatomic, assign) int framesReceived;
@property(nonatomic, assign) int dropped;
@property(nonatomic, assign) int rendered;
@property(nonatomic, assign) int renderFps;
@property(nonatomic, copy) NSString *name;
@property(nonatomic) UIViewContentMode videoContentMode;
@property(nonatomic, strong) NSMutableArray *streamIDsArr;
#endif

- (NSDictionary *)getRenderStates;

/** The size of the frame. */
- (void)setSize:(CGSize)size;

/** The frame to be displayed. */
- (void)renderFrame:(nullable RTC_OBJC_TYPE(RTCVideoFrame) *)frame;

/***/
- (void)reset;

@end

RTC_OBJC_EXPORT
@protocol RTC_OBJC_TYPE
(RTCVideoViewDelegate)<NSObject>

    - (void)firstFrameRenderedOnVideoView
    : (id<RTC_OBJC_TYPE(RTCVideoRenderer)>)videoView renderFrame
    : (nullable RTC_OBJC_TYPE(RTCVideoFrame) *)frame;

- (void)videoView:(id<RTC_OBJC_TYPE(RTCVideoRenderer)>)videoView didChangeVideoSize:(CGSize)size;

- (void)videoView:(id<RTC_OBJC_TYPE(RTCVideoRenderer)>)videoView
      renderFrame:(nullable RTC_OBJC_TYPE(RTCVideoFrame) *)frame;

@end

NS_ASSUME_NONNULL_END
