//
//  BRTCCoreOCVideoRenderer.h
//  BRTCCoreOC
//
//  Created by lw0717 on 2023/4/27.
//

#import <Foundation/Foundation.h>
#import "RTCMacros.h"
#import "RTCVideoRenderer.h"
#import "BRTCCoreOCDef.h"


@class BRTCCoreOCVideoRenderer;

@protocol BRTCCoreOCVideoRendererDelegate <NSObject>
@optional

- (void)render:(BRTCCoreOCVideoRenderer *)render frame:(RTC_OBJC_TYPE(RTCVideoFrame) *)frame;

@end

RTC_OBJC_EXPORT
@interface BRTCCoreOCVideoRenderer : NSObject

@property (nonatomic, weak) id<BRTCCoreOCVideoRendererDelegate> delegate;

@property (nonatomic, readonly) BOOL isLocal;

- (instancetype)initWithIsLocal:(BOOL)isLocal;

- (void)updateRotation:(BRTCCoreOCVideoRotation)rotation;
- (void)updateMirrorType:(BRTCCoreOCVideoMirrorType)mirrorType;

@end
