//
//  BRTCCoreOCMediaPlayerType.h
//  BRTCCoreOC
//
//  Created by lw0717 on 2024/8/23.
//

#import <Foundation/Foundation.h>
#import "RTCMacros.h"

/// 播放器的状态
typedef NS_ENUM(NSUInteger, BRTCCoreOCMediaPlayerState) {
  BRTCCoreOCMediaPlayerState_IDLE,            ///< 空闲, 播放器会在你打开媒体文件之前和结束播放之后返回该状态码
  BRTCCoreOCMediaPlayerState_OPENING,         ///< 正在打开媒体文件
  BRTCCoreOCMediaPlayerState_OPEN_COMPLETED,  ///< 成功打开媒体文件
  BRTCCoreOCMediaPlayerState_PLAYING,         ///< 正在播放
  BRTCCoreOCMediaPlayerState_PAUSED,          ///< 暂停播放
  BRTCCoreOCMediaPlayerState_COMPLETED,       ///< 播放完毕
  BRTCCoreOCMediaPlayerState_STOPPED,         ///< 播放已停止
  BRTCCoreOCMediaPlayerState_FAILED           ///< 播放失败
};

// 播放器状态改变的原因
typedef NS_ENUM(NSUInteger, BRTCCoreOCMediaPlayerReason) {
  BRTCCoreOCMediaPlayerReason_NONE = 0,              ///< 没有错误
  BRTCCoreOCMediaPlayerReason_INVALID_ARGUMENTS,     ///< 无效的参数
  BRTCCoreOCMediaPlayerReason_OBJ_NOT_INITIALIZED,   ///< 对象未初始化
  BRTCCoreOCMediaPlayerReason_SRC_BUFFER_UNDERFLOW,  ///< 播放缓冲区数据不足
  BRTCCoreOCMediaPlayerReason_CODEC_NOT_SUPPORTED,   ///< 解码器不支持该 codec
  BRTCCoreOCMediaPlayerReason_UNKNOWN,               ///< 未知错误
};

// 播放器的事件类型
typedef NS_ENUM(NSUInteger, BRTCCoreOCMediaPlayerEvent) {
  BRTCCoreOCMediaPlayerEvent_FIRST_DISPLAYED,  ///< 视频首帧出图
  BRTCCoreOCMediaPlayerEvent_BUFFER_LOW,       ///< 当前缓冲的数据不足以支持播放
  BRTCCoreOCMediaPlayerEvent_BUFFER_RECOVER,   ///< 当前缓冲的数据刚好能支持播放
  BRTCCoreOCMediaPlayerEvent_SEEK_COMPLETE,    ///< seek 完成
  BRTCCoreOCMediaPlayerEvent_SEEK_ERROR,       ///< seek 出错
};

/**
 * @brief 播放器媒体流信息
 *
 */
RTC_OBJC_EXPORT
@interface BRTCCoreOCPlayerStreamInfo : NSObject

/// 是否有视频
@property (nonatomic, assign) BOOL hasVideo;
/// 是否有音频
@property (nonatomic, assign) BOOL hasAudio;
/// 视频宽
@property (nonatomic, assign) int videoWidth;
/// 视频高
@property (nonatomic, assign) int videoHeight;
/// 音频采样率
@property (nonatomic, assign) int audioSampleRate;
/// 音频声道
@property (nonatomic, assign) int audioChannels;

@end

/**
 * @brief 播放器音视频统计信息
 *
 */
RTC_OBJC_EXPORT
@interface BRTCCoreOCMediaPlayerStats : NSObject

/// 视频帧率
@property (nonatomic, assign) int frameRate;
/// 视频码率，单位Kbps
@property (nonatomic, assign) int videoBitrate;
/// 音频码率，单位Kbps
@property (nonatomic, assign) int audioBitrate;
/// 总码率，单位Kbps
@property (nonatomic, assign) int totalBitrate;

@end
