//
//  BRTCCoreOC+ADM.h
//  BRTCCoreOC
//
//  Created by DeskMac on 2023/5/22.
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>

#import "BRTCCoreOC.h"

NS_ASSUME_NONNULL_BEGIN

RTC_OBJC_EXPORT
@interface BRTCCoreOC (ADM)

/**
 * audiosession 配置
 * @param volumeType 音量类型配置
 */
- (void)configRTCAudioSessionByvolumeType:(BRTCCoreOCVolumeType)volumeType;

/**
 * 音频路由切换
 * @param audioRoute 音频输出路由端口
 */
- (BOOL)setAudioRoute:(BRTCCoreOCAudioRoute)audioRoute;

/**
 * 音量类型切换
 * @param volumeType 系统音量类型切换
 */
- (BOOL)switchToVolumeType:(BRTCCoreOCVolumeType)volumeType;

/**
 * 获取当前音频输出端口
 */
- (AVAudioSessionPort)getAudioSessionPortType;

/**
 * 重置 adm
 */
- (BOOL)resetAudioModuld;

/**
 * 调整 adm 音频自定义策略
 */
- (void)setLogicType:(BRTCCoreOCCustomLogicType)logicType;

@end

NS_ASSUME_NONNULL_END
