//
//  BrtcEngineKit.h
//  BRTC-i
//
//  Created by lw0717 on 2024/1/3.
//  Copyright © 2024 BRTC. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <BRTC/BrtcEnumerates.h>
#import <BRTC/BrtcMediaIO.h>
#import <BRTC/BrtcObjects.h>

NS_ASSUME_NONNULL_BEGIN

@class BrtcEngineKit;

@protocol BrtcEngineDelegate <NSObject>

@optional
- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
   didJoinChannel:(NSString * _Nonnull)channel
          withUid:(NSUInteger)uid
          elapsed:(NSInteger) elapsed;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
 didRejoinChannel:(NSString * _Nonnull)channel
          withUid:(NSUInteger)uid
          elapsed:(NSInteger) elapsed;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
    didOccurError:(BrtcErrorCode)errorCode;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
firstLocalVideoFrameWithSize:(CGSize)size
          elapsed:(NSInteger)elapsed;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
firstLocalAudioFrame:(NSInteger)elapsed;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
localVideoStateChange:(BrtcLocalVideoStreamState)state
            error:(BrtcLocalVideoStreamError)error;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
   didJoinedOfUid:(NSUInteger)uid
          elapsed:(NSInteger)elapsed;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
  didOfflineOfUid:(NSUInteger)uid
           reason:(BrtcUserOfflineReason)reason;

- (void)rtcEngineConnectionDidLost:(BrtcEngineKit * _Nonnull)engine;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
  didAudioEnabled:(BOOL)enabled
            byUid:(NSUInteger)uid;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
    didAudioMuted:(BOOL)muted
            byUid:(NSUInteger)uid;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
  didVideoEnabled:(BOOL)enabled
            byUid:(NSUInteger)uid;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
    didVideoMuted:(BOOL)muted
            byUid:(NSUInteger)uid;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
  lastmileQuality:(BrtcNetworkQuality)quality;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
firstRemoteVideoDecodedOfUid:(NSUInteger)uid
             size:(CGSize)size
          elapsed:(NSInteger)elapsed;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
firstRemoteAudioFrameDecodedOfUid:(NSUInteger)uid
          elapsed:(NSInteger)elapsed;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
firstRemoteVideoFrameOfUid:(NSUInteger)uid
             size:(CGSize)size
          elapsed:(NSInteger)elapsed;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
firstRemoteAudioFrameOfUid:(NSUInteger)uid
          elapsed:(NSInteger)elapsed;

- (void)rtcEngineConnectionDidInterrupted:(BrtcEngineKit * _Nonnull)engine;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
   networkQuality:(NSUInteger)uid
        txQuality:(BrtcNetworkQuality)txQuality
        rxQuality:(BrtcNetworkQuality)rxQuality;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
videoTransportStatsOfUid:(NSUInteger)uid
            delay:(NSUInteger)delay
             lost:(NSUInteger)lost
       rxKBitRate:(NSUInteger)rxKBitRate;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
audioTransportStatsOfUid:(NSUInteger)uid
            delay:(NSUInteger)delay
             lost:(NSUInteger)lost
       rxKBitRate:(NSUInteger)rxKBitRate;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine 
   reportRtcStats:(BrtcChannelStats * _Nonnull)stats;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
  localVideoStats:(BrtcLocalVideoStats * _Nonnull)stats;

- (void)rtcEngine:(BrtcEngineKit * _Nonnull)engine
connectionChangedToState:(BrtcConnectionStateType)state
           reason:(BrtcConnectionChangedReason)reason;

@end

@interface BrtcEngineKit : NSObject

+ (instancetype _Nonnull)sharedEngineWithAppId:(NSString * _Nonnull)appId
                                      delegate:(id<BrtcEngineDelegate> _Nullable)delegate;

+ (instancetype _Nonnull)sharedEngineWithConfig:(BrtcEngineConfig * _Nonnull)config
                                       delegate:(id<BrtcEngineDelegate> _Nullable)delegate;

+ (void)destroy;

+ (NSString * _Nonnull)getSdkVersion;

@property (nonatomic, weak) id<BrtcEngineDelegate> _Nullable delegate;

- (int)setChannelProfile:(BrtcChannelProfile)profile;

- (int)setClientRole:(BrtcClientRole)role;

- (int)joinChannelByToken:(NSString * _Nullable)token
                channelId:(NSString * _Nonnull)channelId
                     info:(NSString * _Nullable)info
                      uid:(NSUInteger)uid;

- (int)joinChannelByToken:(NSString * _Nullable)token
                channelId:(NSString * _Nonnull)channelId
                     info:(NSString * _Nullable)info
                      uid:(NSUInteger)uid
              joinSuccess:(void(^ _Nullable)(NSString * _Nonnull channel, NSUInteger uid, NSInteger elapsed))joinSuccessBlock;

- (int)leaveChannel:(void(^ _Nullable)(BrtcChannelStats * _Nonnull stat))leaveChannelBlock;

- (int)enableWebSdkInteroperability:(BOOL)enabled;

- (int)enableAudio;

- (int)disableAudio;

- (int)setAudioProfile:(BrtcAudioProfile)profile
              scenario:(BrtcAudioScenario)scenario;

- (int)muteLocalAudioStream:(BOOL)mute;

- (int)enableVideo;

- (int)disableVideo;

- (int)setVideoEncoderConfiguration:(BrtcVideoEncoderConfiguration * _Nonnull)config;

- (int)setupLocalVideo:(BrtcVideoCanvas * _Nullable)local;

- (int)setupRemoteVideo:(BrtcVideoCanvas * _Nonnull)remote;

- (int)enableLocalVideo:(BOOL)enabled;

- (int)muteLocalVideoStream:(BOOL)mute;

- (int)enableInEarMonitoring:(BOOL)enabled;

- (int)setInEarMonitoringVolume:(NSInteger)volume;

- (int)startAudioMixing:(NSString *_Nonnull)filePath
               loopback:(BOOL)loopback
                replace:(BOOL)replace
                  cycle:(NSInteger)cycle
               startPos:(NSInteger)startPos;

- (int)stopAudioMixing;

- (int)pauseAudioMixing;

- (int)resumeAudioMixing;

- (int)setAudioMixingPosition:(NSInteger)pos;

- (int)playEffect:(int)soundId
         filePath:(NSString * _Nullable)filePath
        loopCount:(int)loopCount
            pitch:(double)pitch
              pan:(double)pan
             gain:(double)gain
          publish:(BOOL)publish
         startPos:(int)startPos;

- (int)stopEffect:(int)soundId;

- (void)setVideoSource:(id<BrtcVideoSourceProtocol> _Nullable)videoSource;

- (int)setLocalVideoMirrorMode:(BrtcVideoMirrorMode)mode;

- (int)switchCamera;

- (CGFloat)setCameraZoomFactor:(CGFloat)zoomFactor;

@end

NS_ASSUME_NONNULL_END
