//
//  BRTCDeviceManager+Ext.h
//  BRTC-i
//
//  Created by lw0717 on 2023/2/13.
//  Copyright © 2023 BJY. All rights reserved.
//

#import <BRTC/BRTC.h>
#import <BRTC/BRTCDeviceManager.h>
#import <AVFoundation/AVFoundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * Module:   BRTCDeviceManager
 *
 * Function: BRTCDeviceManager 扩充方法。试验性接口，不建议使用。
 */
@interface BRTCDeviceManager()

/**
 * Returns list of available capture devices that support video capture. only Vloud
 */
- (NSArray<AVCaptureDevice *> *)captureDevices;

/**
 * Returns list of formats that are supported by this class for this device. only Vloud
 */
- (NSArray<AVCaptureDeviceFormat *> *)supportedFormatsForDevice:(AVCaptureDevice *)device;

- (BRTCAudioRoute)getCurrentAudioRoute;

@end

NS_ASSUME_NONNULL_END
