//
//  BRTCBLiveView.h
//  BRTC-i
//
//  Created by lw0717 on 2025/3/25.
//  Copyright © 2025 BRTC. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <BRTC/BRTCDef.h>

NS_ASSUME_NONNULL_BEGIN

@interface BRTCBLiveView : UIView

//@property (nonatomic) NSArray<HttpDnsUrls*>* httpDnsUrl;
//@property (nonatomic) NSNumber *timeout;
//@property (nonatomic) NSString *ip_url;
//@property (nonatomic) NSString *ip;
//
///// 当前播放视图所关联的合流信息
//@property (nonatomic, nullable) NSArray<BLiveMixStreamDefinitionInfo *> *mixStreamInfo;

/// 尺寸变化回调
@property (nonatomic, copy) void (^playerSizeChangeCallback)(CGSize size);

@property (nonatomic, readonly) UIView *mediaView;

/// 设置缓存最大延迟时间
- (void)setMaxBufferTime:(int)maxBufferTime;
- (int)getMaxBufferTime;

/// 设置显示模式
- (void)setFitMode:(BRTCBliveFitMode)fitMode;

/// 停止播放，清理播放视图
- (void)clear;


@end

NS_ASSUME_NONNULL_END
