//
//  BRTC+Ext.h
//  BRTC
//
//  Created by lw0717 on 2023/5/24.
//  Copyright © 2023 BRTC. All rights reserved.
//

#import <BRTC/BRTC.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * BRTC扩充方法。试验性接口，不建议使用。
 */
@interface BRTC (Ext)
/////////////////////////////////////////////////////////////////////////////////
//
//                   一流多显相关接口函数
//
/////////////////////////////////////////////////////////////////////////////////

/**
 * 增加本地预览视频的渲染视图
 *
 * @note 如果没有开启本地摄像头则不会渲染
 */
- (void)addLocalPreview:(BRTCView *)view;

/**
 * 移除指定的本地预览视频的渲染视图
 */
- (void)removeLocalPreview:(BRTCView *)view;

/**
 * 增加指定 userId  和 streamType 的远端流的渲染视图
 *
 * @note 如果没有开始拉取该远端流则不会渲染
 */
- (void)addRemoteView:(NSString *)userId streamType:(BRTCVideoStreamType)streamType view:(BRTCView *)view;

/**
 * 移除指定的 userId 和 streamType 的远端流的渲染视图
 */
- (void)removeRemoteView:(NSString *)userId streamType:(BRTCVideoStreamType)streamType view:(BRTCView *)view;

/**
 * 拉取更多用户，仅大房间模式有效
 *
 * 通过 -onUserListLastPage: 回调返回
 *
 * @param count 拉取用户的数量。传0则本次调用无效。
 */
- (void)pullUsersWithCount:(NSUInteger)count;

/////////////////////////////////////////////////////////////////////////////////
//
//                   屏幕共享扩展功能相关接口函数
//
/////////////////////////////////////////////////////////////////////////////////

/**
 * 控制共享推双流情况下，共享流方向
 *
 * @param rotation 推流方向
 */
- (void)setScreenShareRotation:(BRTCVideoRotation)rotation;

/**
 * 控制共享推双流情况下，共享流方向的控制逻辑
 *
 * @param logic 流方向控制逻辑
 */
- (void)setScreenShareRotationLogic:(BRTCScreenShareRotationLogic)logic;

@end

NS_ASSUME_NONNULL_END
